;*********************************
;* Jungle Jag - JagCode 500 Game *
;*********************************
;
; by Cedric Bourse, (a.k.a Orion_) [2007]
;
; http://onorisoft.info/
;
; This Source Code is licensed under the term of the following Creative Commons License:
; http://creativecommons.org/licenses/by-nc/3.0/
;
; You are free:
;  * to Share : to copy, distribute and transmit the work
;  * to Remix : to adapt the work
;
; Under the following conditions:
;  * Attribution. You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).
;  * Noncommercial. You may not use this work for commercial purposes.
;  * For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.
;  * Any of the above conditions can be waived if you get permission from the copyright holder.
;  * Nothing in this license impairs or restricts the author's moral rights.
;

;************************************************
;* Jaguar Initialisation Lib * by Orion_ [2006] *
;************************************************


	.text

;-----------
; Init Jag -
;-----------
	move.w	#$100,JOYSTICK			; mute
	moveq	#0,d0
	move.l	d0,G_CTRL
	move.l	d0,D_CTRL
	move.l	d0,G_FLAGS
	move.l	d0,D_FLAGS
	move.l	#$70007,G_END			; big-endian mode
	move.l	#$70007,D_END
	move.w	#%11010111001100,MEMCON2	; big-endian memory
	move.w	#$FFFF,VI			; disable video interrupts
	move.w	#$2000,sr			; SuperVisor Mode and all Interrupt Enabled for 68k
	move.l	#INITSTACK,a7			; Setup a stack
	bra	Start

	.qphrase

	dc.b	13,10
	dc.b	"********************",13,10
	dc.b	"* -JaguarLib v0.9- *",13,10
	dc.b	"* by Orion_ [2006] *",13,10
	dc.b	"********************",13,10

	.long

;-------------
; Init Video -
;-------------
InitVideo:
	movem.l	d0-d6,-(a7)
	move.w	CONFIG,d0
	andi.w	#VIDTYPE,d0	; 0 = PAL, 1 = NTSC
	beq.s	palvals
	move.w	#NTSC_HMID,d2
	move.w	#NTSC_WIDTH,d0
	move.w	#NTSC_VMID,d6
	move.w	#NTSC_HEIGHT,d4
	bra.s	calc_vals
palvals:
	move.w	#PAL_HMID,d2
	move.w	#PAL_WIDTH,d0
	move.w	#PAL_VMID,d6
	move.w	#PAL_HEIGHT,d4
calc_vals:
	move.w	d0,width
	move.w	d4,height
	move.w	d0,d1
	asr	#1,d1
	sub.w	d1,d2
	add.w	#4,d2
	sub.w	#1,d1
	ori.w	#$400,d1
	move.w	d1,a_hde
	move.w	d1,HDE
	move.w	d2,a_hdb
	move.w	d2,HDB1
	move.w	d2,HDB2
	move.w	d6,d5
	sub.w	d4,d5
	move.w	d5,a_vdb
	add.w	d4,d6
	move.w	d6,a_vde
	move.w	a_vdb,VDB
	move.w	#$FFFF,VDE
	move.l	#0,BORD1
	move.w	#0,BG

	move.w	#256-1,d0	; Clear Palette
	lea	CLUT,a0
.clrpal:
	clr.w	(a0)+
	dbra	d0,.clrpal

	movem.l	(a7)+,d0-d6
	rts


;---------------------------------------
; Init VBL Interrupt: a0 = VBL Routine -
;---------------------------------------
InitVBLInt:
	move.l	a0,LEVEL0
	move.w	a_vde,d0
	ori.w	#1,d0
	move.w	d0,VI
	move.w	#C_VIDENA,INT1
	andi.w	#$f8ff,sr
	rts


;--------------------
; VBL Interrupt Ack -
;--------------------
.macro	VBLIntAck
	move.w	#$101,INT1
	move.w	#$0,INT2
.endm


;------------
; Start DSP -
;------------
.macro	StartDSP
	move.l	#D_RAM,D_PC
	move.l	#1,D_CTRL
.endm

.macro	StartDSP_At	dpos
	move.l	#\dpos,D_PC
	move.l	#1,D_CTRL
.endm


;------------
; Start GPU -
;------------
.macro	StartGPU
	move.l	#G_RAM,G_PC
	move.l	#1,G_CTRL
.endm

.macro	StartGPU_At	gpos
	move.l	#\gpos,G_PC
	move.l	#1,G_CTRL
.endm


;-----------------
; Set Video Mode -
;-----------------
.macro	SetVideoMode	color
	move.w	#\color|CSYNC|BGEN|PWIDTH4|VIDEN,VMODE
.endm


;-------------------------
; Copy GPU Code in Cache -
;-------------------------

CopyGPUCode:
	move.l	#GPUCode,a0
	move.l	#G_RAM,a1
	move.l	#GPUEnd,d7
	sub.l	a0,d7
	lsr.l	#2,d7
.cgcl:	move.l	(a0)+,(a1)+
	dbra	d7,.cgcl
	rts


;-------------------------
; Copy DSP Code in Cache -
;-------------------------

CopyDSPCode:
	move.l	#DSPCode,a0
	move.l	#D_RAM,a1
	move.l	#DSPEnd,d7
	sub.l	a0,d7
	lsr.l	#2,d7
.cdcl:	move.l	(a0)+,(a1)+
	dbra	d7,.cdcl
	rts


;---------------
; Wait the GPU -
;---------------

WaitGPU:
	lea	G_CTRL,a0
.waitgpu1:
	move.l	(a0),d0
	andi.w	#1,d0
	bne.s	.waitgpu1
	rts


;---------------
; Wait the DSP -
;---------------

WaitDSP:
	lea	D_CTRL,a0
.waitdsp1:
	move.l	(a0),d0
	andi.w	#1,d0
	bne.s	.waitdsp1
	rts


;------------
; DSP Macro -
;------------

	.DSP

.macro	call	adr
	subq	#4,r31
	move	PC,r30
	addq	#16,r30
	store	r30,(r31)
	movei	#\adr,r30
	jump	(r30)
	nop
.endm


.macro	ret
	load	(r31),r30
	addq	#4,r31
	jump	(r30)
	nop
.endm


.macro	InitDSPStack
	movei	#D_RAM+(8*1024),r31
	moveta	r31,r31
.endm


.macro	StopDSP
	movei	#D_CTRL,r0
	movei	#0,r1
	store	r1,(r0)
	nop
.endm


;------------
; GPU Macro -
;------------

	.GPU

.macro	StopGPU
	movei	#G_CTRL,r0
	movei	#0,r1
	store	r1,(r0)
	nop
.endm


	.68000

;-----------
;-- Datas --
;-----------

	.data

a_hdb:	dc.w	0
a_hde:	dc.w	0
a_vdb:	dc.w	0
a_vde:	dc.w	0
width:	dc.w	0
height:	dc.w	0

	.text
